% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_negbin.R
\name{negbin_overdispersion}
\alias{negbin_overdispersion}
\title{Computes the overdispersion parameter for a fitted negative binomial model.}
\usage{
negbin_overdispersion(table)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{mu, theta} and possibly
others.}
}
\value{
The same table, with a new column \code{overdispersion}.
}
\description{
Computes the overdispersion parameter \eqn{w=1+\mu/\theta} for a negative
binomial distribution parametrized by its expected value \eqn{\mu} and with 
variance \eqn{\mu+\mu^2/\theta}. The overdispersion is added as a new column 
to the input \code{data.table}, meaning that this function \code{modifies} 
its input.
}
\keyword{internal}

