% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanstatistics_general.R
\name{gumbel_pvalue}
\alias{gumbel_pvalue}
\title{Calculate the Gumbel \eqn{p}-value for a scan statistic.}
\usage{
gumbel_pvalue(observed, replicates, method = "ML")
}
\arguments{
\item{observed}{A scalar containing the observed value of the scan statistic,
or a vector of observed values from secondary clusters.}

\item{replicates}{A vector of Monte Carlo replicates of the scan statistic.}

\item{method}{Either "ML", for maximum likelihood, or "MoM", for method of 
moments.}
}
\value{
The \eqn{p}-value or \eqn{p}-values corresponding to the observed 
   scan statistic(s).
}
\description{
Given an observed scan statistic \eqn{\lambda^*} and a vector of replicate 
scan statistics \eqn{\lambda_i}, \eqn{i=1,\ldots,R}, fit a Gumbel 
distribution to the replicates and calculate a \eqn{p}-value for the observed
statistic based on the fitted distribution.
\deqn{
 \frac{1 + \sum_{i=1}^R \mathrm{I}(\lambda_i > \lambda^*)}{1 + R}
}
The function is vectorized, so multiple \eqn{p}-values can be calculated if
several scan statistics (e.g. statistics from secondary clusters) are 
supplied.
}
\keyword{internal}
