% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{changeMouseMode}
\alias{changeMouseMode}
\title{This function allows to set the type of interaction; three types of mouse interactions are available ('tooltip', 'filter' or 'zoom').}
\usage{
changeMouseMode(id, interactionType)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{interactionType}{Type of mouse interaction.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
This function allows to set the type of interaction; three types of mouse interactions are available ('tooltip', 'filter' or 'zoom').
}
\examples{
 if(interactive()) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     selectInput(
       "mouseMode", 
       "Mouse Interactions:", 
       c("Tooltip" = "tooltip", "Filter" = "filter", "Zoom" = "zoom")
     ),
     p("The selector controls the type of mouse interactions with the scatterPlotMatrix"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })
     observe({
       scatterPlotMatrix::changeMouseMode("spMatrix", input$mouseMode)
     })
   }

   shinyApp(ui, server)
 }

}
