% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REML-ES-functions.R
\name{Info_Expected_lmeAR1}
\alias{Info_Expected_lmeAR1}
\title{Calculate expected information matrix}
\usage{
Info_Expected_lmeAR1(m_fit)
}
\arguments{
\item{m_fit}{Fitted model of class lme, with AR(1) correlation structure at level 1.}
}
\value{
Expected Information matrix corresponding to variance components of \code{m_fit}.
}
\description{
Calculates the expected information matrix from a fitted linear mixed effects
model with AR(1) correlation structure in the level-1 errors.
}
\examples{
data(Laski)
Laski_RML <- lme(fixed = outcome ~ treatment, 
                 random = ~ 1 | case, 
                 correlation = corAR1(0, ~ time | case), 
                 data = Laski)
Info_Expected_lmeAR1(Laski_RML)
}

