% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{JMatToCsv}
\alias{JMatToCsv}
\title{JMatToCsv}
\usage{
JMatToCsv(ifile, csvfile, csep = ",", withquotes = FALSE)
}
\arguments{
\item{ifile}{String with the file name that contains the binary data.}

\item{csvfile}{String with the file name that will contain the data as csv.}

\item{csep}{Character used as separator. Default: , (comma)}

\item{withquotes}{boolean to mark if row and column names in the .csv file must be written surrounded by doble quotes. Default: FALSE}
}
\value{
No return value, called for side effects (creates a file)
}
\description{
Writes a binary matrix in the jmatrix package format as a .csv file. This is mainly for checking/inspection and
to load the data from R as read.table, if the memory of having all data as doubles allows doing such thing.
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
tmpcsvfile1=paste0(tempdir(),"/Rfullfloat.csv")
JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
JMatToCsv(tmpfile1,tmpcsvfile1)
}
