% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_design.R
\name{scf_design}
\alias{scf_design}
\title{Construct SCF Core Data Object}
\usage{
scf_design(design, year, n_households)
}
\arguments{
\item{design}{A list of five \code{\link[survey:svrepdesign]{survey::svrepdesign()}} objects (one per implicate).}

\item{year}{Numeric SCF survey year (e.g., 2022).}

\item{n_households}{Numeric total U.S. households represented in \code{year}.}
}
\value{
An object of class "scf_mi_survey" with:
\describe{
\item{mi_design}{List of replicate-weighted designs (one per implicate).}
\item{year}{SCF survey year.}
\item{n_households}{Estimated number of U.S. households.}
}
}
\description{
Stores SCF microdata as five implicate-specific designs created by
\code{\link[survey:svrepdesign]{survey::svrepdesign()}}. Raw implicate data frames are not retained.
}
\details{
Wrap a list of replicate-weighted survey designs into an "scf_mi_survey".
Typically called by \code{\link[=scf_load]{scf_load()}}.
}
\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Construct scf_mi_survey object
obj <- scf_design(
  design = scf2022$mi_design,
  year = 2022,
  n_households = attr(scf2022, "n_households")
)
class(obj)
length(obj$mi_design)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_load]{scf_load()}}, \code{\link[=scf_update]{scf_update()}}
}
