% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_xtab.R
\name{scf_xtab}
\alias{scf_xtab}
\title{Cross-Tabulate Two Discrete Variables in Multiply-Imputed SCF Data}
\usage{
scf_xtab(scf, rowvar, colvar, scale = "cell")
}
\arguments{
\item{scf}{A \code{scf_mi_survey} object, typically created by \code{\link[=scf_load]{scf_load()}}. Must include five implicates with replicate weights.}

\item{rowvar}{A one-sided formula specifying the row variable (e.g., \code{~edcl}).}

\item{colvar}{A one-sided formula specifying the column variable (e.g., \code{~racecl}).}

\item{scale}{Character. Proportion basis: "cell" (default), "row", or "col".}
}
\value{
A list of class \code{"scf_xtab"} with:
\describe{
\item{results}{Data frame with one row per cell. Columns: \code{row}, \code{col}, \code{prop}, \code{se}, \code{row_share}, \code{col_share}, \code{rowvar}, and \code{colvar}.}
\item{matrices}{List of matrices: \code{cell} (default proportions), \code{row}, \code{col}, and \code{se}.}
\item{imps}{List of implicate-level cell count tables.}
\item{aux}{List with \code{rowvar} and \code{colvar} names.}
}
}
\description{
Computes replicate-weighted two-way cross-tabulations of two discrete variables
using multiply-imputed SCF data. Estimates cell proportions and standard errors,
with optional scaling of proportions by cell, row, or column. Results are pooled
across implicates using Rubin's Rules.
}
\section{Statistical Notes}{

Implicate-level tables are created using \code{svytable()} on replicate-weighted designs.
Proportions are calculated as shares of total population estimates. Variance across
implicates is used to estimate uncertainty. Rubin's Rules are applied in simplified form.

For technical details on pooling logic, see \code{\link[=scf_MIcombine]{scf_MIcombine()}} or the SCF package manual.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Cross-tabulate ownership by education
scf_xtab(scf2022, ~own, ~edcl, scale = "row")

# Do not implement these lines in real analysis: Cleanup for package check
unlink(file.path(td, "scf2022.rds"), force = TRUE)
rm(scf2022)

}
