% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSCCellBrowser.R
\name{ExtractCBComposition}
\alias{ExtractCBComposition}
\title{Extract Cell Type Composition of UCSC Cell Browser Datasets.}
\usage{
ExtractCBComposition(
  json.folder = NULL,
  sample.df = NULL,
  all.samples.df = NULL,
  collection = NULL,
  sub.collection = NULL,
  organ = NULL,
  disease = NULL,
  organism = NULL,
  project = NULL,
  fuzzy.match = TRUE,
  cell.num = NULL
)
}
\arguments{
\item{json.folder}{Folder contains datasets json files, same as \code{json.folder} of \code{ShowCBDatasets}.
Default: NULL (current working directory).}

\item{sample.df}{Dataframe contains used datasets. Default: NULL.}

\item{all.samples.df}{Dataframe contains all samples metadata, obtained with \code{ShowCBDatasets}. Default: NULL.
\code{sample.df} and \code{all.samples.df} cannot be both NULL.}

\item{collection}{The collection of the datasets, corresponds to \code{shortLabel} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{sub.collection}{The sub-collection of the datasets, corresponds to \code{subLabel} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{organ}{The organ of the datasets, corresponds to \code{body_parts} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{disease}{The disease of the datasets, corresponds to \code{diseases} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{organism}{The specie of the datasets, corresponds to \code{organisms} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{project}{The project of the datasets, corresponds to \code{projects} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{fuzzy.match}{Logical value, whether to perform fuzzy match with provided attribute values. Default: TRUE.}

\item{cell.num}{Cell number filter. If NULL, no filter; if one value, lower filter; if two values, low and high filter. Deault: NULL.}
}
\value{
Dataframe contains sample information and cell type composition.
}
\description{
Extract Cell Type Composition of UCSC Cell Browser Datasets.
}
\examples{
\dontrun{
# lazy mode, load datasets json files locally, need users to provide json folder
ucsc.cb.samples <- ShowCBDatasets(lazy = TRUE, json.folder = NULL, update = FALSE)
# cell number is between 1000 and 2000
hbb.sample.df <- ExtractCBDatasets(
  all.samples.df = ucsc.cb.samples, organ = c("brain", "blood"),
  organism = "Human (H. sapiens)", cell.num = c(1000, 2000)
)
hbb.sample.ct <- ExtractCBComposition(json.folder = NULL, sample.df = hbb.sample.df)
}
}
