% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataIO.R
\name{SCEAnnData}
\alias{SCEAnnData}
\title{Data Format Conversion between SingleCellExperiment and AnnData.}
\usage{
SCEAnnData(
  from = c("SingleCellExperiment", "AnnData"),
  to = c("AnnData", "SingleCellExperiment"),
  sce = NULL,
  anndata.file = NULL,
  slot.name = "counts",
  ...
)
}
\arguments{
\item{from}{The source data format to convert, chosen from SingleCellExperiment and AnnData.
Default: SingleCellExperiment.}

\item{to}{The target data format to convert, chosen from AnnData and SingleCellExperiment.
Default: AnnData.}

\item{sce}{The SingleCellExperiment object to convert. Default: NULL.}

\item{anndata.file}{File used to save or contains AnnData results. Default: NULL.}

\item{slot.name}{Slot name used to save count matrix, used when converting from AnnData to SingleCellExperiment.
Default: counts.}

\item{...}{Parameters for \code{writeH5AD} and \code{readH5AD}.}
}
\value{
NULL or SingleCellExperiment.
}
\description{
Data Format Conversion between SingleCellExperiment and AnnData.
}
\examples{
\dontrun{
library(scRNAseq)
seger <- SegerstolpePancreasData()
SCEAnnData(from = "SingleCellExperiment", to = "AnnData", sce = seger, X_name = "counts")
# need users to provide the output file
sce <- SCEAnnData(
  from = "AnnData", to = "SingleCellExperiment",
  anndata.file = "path/to/seger.h5ad"
)
}
}
