% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sci_figure.R
\name{sci_figure}
\alias{sci_figure}
\title{Create a figure depicting reproducibility/replicability of a set of
scientific experiments}
\usage{
sci_figure(experiments, hide_stages = NULL, names_of_stages = TRUE)
}
\arguments{
\item{experiments}{A data frame, which can be initialized with \code{init_experiments()},
whose rownames are the predefined stages of a scientifc experiments, columnnames are
the names of each experiment, and cell values represent the state of each stage
in each experiment (states discussed below).}

\item{hide_stages}{(optional) A character vector with the names of the stages
in the scientific experiment, i.e. rownames of \code{experiments}, which the user wishes
to suppress from the figure output. The default value of \code{hide_stages} is NULL, indicating
that all stages will be displayed.}

\item{names_of_stages}{Logical indicating whether or not the names of the
stages should be displayed.}
}
\description{
\code{sci_figure} creates a graphical representation of changes in a
a set of subsequent studies or reproduction attempts as compared to an 
original study.
}
\note{
For the parameter \code{experiments}, the four values any cell may take
are: \code{observed}, \code{different}, \code{unobserved}, \code{incorrect}.
}
\examples{

# Initialize the default experiments data frame
exps <- init_experiments()
sci_figure(exps)
sci_figure(exps, hide_stages = c("population", "analyst"))

# Do some manual manipulation to the experiments

exps["analyst", "Exp2"] <- "different"
exps["code", c("Exp2", "Exp3")] <- "unobserved"
sci_figure(exps)

}
\seealso{
\code{\link{init_experiments}}
}
