% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_adj}
\alias{woebin_adj}
\title{WOE Binning Adjustment}
\usage{
woebin_adj(bins, dt, y, all_var = FALSE, count_distr_limit = 0.05)
}
\arguments{
\item{bins}{A list or data frame. Binning information generated by \code{woebin}.}

\item{dt}{A data frame.}

\item{y}{Name of y variable.}

\item{all_var}{Logical, default FALSE. It means whether to adjust all variables' binning breaks.}

\item{count_distr_limit}{The count_distr limit to adjust binning breaks, default 0.05.}
}
\description{
\code{woebin_adj} interactively adjust the binning breaks.
}
\examples{
\dontrun{
# Load German credit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "age.in.years", "credit.amount")]
bins = woebin(dt, y="creditability")
breaks_adj = woebin_adj(bins, dt, y="creditability")
bins_final = woebin(dt, y="creditability",
                    breaks_list=breaks_adj)

# Example II
binsII = woebin(germancredit, y="creditability")
breaks_adjII = woebin_adj(binsII, germancredit, "creditability")
bins_finalII = woebin(germancredit, y="creditability",
                    breaks_list=breaks_adjII)
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_plot}}
}
