% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_value.R
\name{iv}
\alias{iv}
\title{Information Value}
\usage{
iv(dt, y, x = NULL, positive = "bad|1", order = TRUE)
}
\arguments{
\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. Default is NULL. If x is NULL, then all variables except y are counted as x variables.}

\item{positive}{Value of positive class, default is "bad|1".}

\item{order}{Logical, default is TRUE. If it is TRUE, the output will descending order via iv.}
}
\value{
Information Value
}
\description{
This function calculates information value (IV) for multiple x variables.
}
\details{
IV is a very useful concept for variable selection while developing credit scorecards. The formula for information value is shown below: \deqn{IV = \sum(DistributionBad_{i} - DistributionGood_{i})*\ln(\frac{DistributionBad_{i}}{DistributionGood_{i}}).} The log component in information value is defined as weight of evidence (WOE), which is shown as \deqn{WeightofEvidence = \ln(\frac{DistributionBad_{i}}{DistributionGood_{i}}).}
The relationship between information value and predictive power is as follows:
\tabular{rr}{
Information Value \tab Predictive Power \cr
----------------- \tab ---------------- \cr
< 0.02 \tab useless for prediction \cr
0.02 to 0.1 \tab Weak predictor \cr
0.1 to 0.3 \tab Medium predictor \cr
> 0.3 \tab Strong predictor
}
}
\examples{
# Load German credit data
data(germancredit)

# information values
info_value = iv(germancredit, y = "creditability")

str(info_value)

}
