% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_logis.R
\name{scores_logis}
\alias{scores_logis}
\alias{crps_logis}
\alias{crps_clogis}
\alias{crps_tlogis}
\alias{crps_gtclogis}
\alias{logs_logis}
\alias{logs_tlogis}
\alias{dss_logis}
\alias{gradcrps_logis}
\alias{gradcrps_clogis}
\alias{gradcrps_tlogis}
\alias{hesscrps_logis}
\alias{hesscrps_clogis}
\alias{hesscrps_tlogis}
\title{Calculating scores for the logistic distribution}
\usage{
## score functions
crps_logis(y, location = 0, scale = 1)
crps_clogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_tlogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_gtclogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf, lmass = 0, umass = 0)
logs_logis(y, location = 0, scale = 1)
logs_tlogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
dss_logis(y, location = 0, scale = 1)

## gradient (location, scale) functions
gradcrps_logis(y, location = 0, scale = 1)
gradcrps_clogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
gradcrps_tlogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)

## Hessian (location, scale) functions
hesscrps_logis(y, location = 0, scale = 1)
hesscrps_clogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
hesscrps_tlogis(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{y}{vector of observations.}

\item{location}{vector of location parameters.}

\item{scale}{vector of scale paramters.}

\item{lower, upper}{lower and upper truncation/censoring bounds.}

\item{lmass, umass}{vectors of point masses in \code{lower} and \code{upper}
respectively.}
}
\value{
For the score functions: a vector of score values.

For the gradient and Hessian functions: a matrix with column names
corresponding to the respective partial derivatives.
}
\description{
These functions calculate scores (CRPS, logarithmic score) and its gradient and Hessian with respect
to the parameters of a location-scale transformed logistic
distribution. Furthermore, the censoring transformation and
the truncation transformation may be introduced on top of the
location-scale transformed logistic distribution.
}
