% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivoting_functions.R
\name{quantile_to_long}
\alias{quantile_to_long}
\title{Pivot Quantile Forecasts From Wide to Long Format}
\usage{
quantile_to_long(data)
}
\arguments{
\item{data}{a data.frame following the specifications from
\code{\link{eval_forecasts}}) for quantile forecasts. For an example, see
\code{\link{quantile_example_data_wide}})}
}
\value{
a data.frame in long format
}
\description{
Given a data.frame that follows the structure shown in
\code{\link{quantile_example_data_wide}}, the function outputs the same
data in a long format as (as shown in
\code{\link{quantile_example_data_long}}). This can be useful e.g. for
plotting.
}
\examples{
wide <- scoringutils::quantile_example_data_wide
long <- scoringutils::quantile_to_long(wide)

}
