% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivoting_functions.R
\name{quantile_to_wide}
\alias{quantile_to_wide}
\title{Pivot Quantile Forecasts From Long to Wide Format}
\usage{
quantile_to_wide(data)
}
\arguments{
\item{data}{a data.frame following the specifications from
\code{\link{eval_forecasts}}) for quantile forecasts. For an example, see
\code{\link{quantile_example_data_long}})}
}
\value{
a data.frame in wide format
}
\description{
Given a data.frame that follows the structure shown in
\code{\link{quantile_example_data_long}}, the function outputs the same
data in a long format as (as shown in
\code{\link{quantile_example_data_wide}}). This can be useful e.g. for
plotting.
}
\examples{
long <- scoringutils::quantile_example_data_long
wide <- scoringutils::quantile_to_wide(long)

}
