% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{subset_cols}
\alias{subset_cols}
\title{Subset cells}
\usage{
subset_cols(acset, sel.ind)
}
\arguments{
\item{acset}{An acset list created by the \code{\link{new_acset}} function.}

\item{sel.ind}{A vector with either integer column indices or a character
vector to subset the colnames.}
}
\value{
acset An acset list where every element containing cell-related
information has been subsetted
}
\description{
\code{subset_cols} subsets the cells of an acset
}
\examples{
##create a small artificial genotype matrix
ncells = 10
paternal = c(0, 2, 0, 0, 2)
maternal = c(2, 0, 2, 2, 0)
gt = as.matrix(as.data.frame(rep(list(paternal, maternal), ncells / 2)))
vars = 1:nrow(gt)
colnames(gt) = 1:ncells
rownames(gt) = vars

##create a feature annotation data-frame
nvars = nrow(gt)
featdata = as.data.frame(matrix(cbind(rep('jfeat', nvars),
as.character(1:nvars), rep('dummy', nvars), rep('dummy', nvars)), ncol = 4,
dimnames = list(vars, c('feat', 'var', 'ref', 'alt'))), stringsAsFactors =
FALSE)

##create acset
acset = new_acset(featdata, gt = gt)

##subset variants
sel_ind = c(1, 3)
acset = subset_cols(acset, sel_ind)

}

