% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate-count.R
\name{duplicate_count}
\alias{duplicate_count}
\title{Count duplicate values}
\usage{
duplicate_count(x, ignore = NULL, locations_type = c("character", "list"))
}
\arguments{
\item{x}{Vector or data frame.}

\item{ignore}{Optionally, a vector of values that should not be counted.}

\item{locations_type}{String. One of \code{"character"} or \code{"list"}. With
\code{"list"}, each \code{locations} value is a vector of column names, which is
better for further programming. By default (\code{"character"}), the column
names are pasted into a string, which is more readable.}
}
\value{
If \code{x} is a data frame or another named vector, a tibble with four
columns. If \code{x} isn't named, only the first two columns appear:
\itemize{
\item \code{value}: All the values from \code{x}.
\item \code{frequency}: Absolute frequency of each value in \code{x}, in descending order.
\item \code{locations}: Names of all columns from \code{x} in which \code{value} appears.
\item \code{locations_n}: Number of columns named in \code{locations}.
}

The tibble has the \code{scr_dup_count} class, which is recognized by the
\code{\link[=audit]{audit()}} generic.
}
\description{
\code{duplicate_count()} returns a frequency table. When searching a
data frame, it includes values from all columns for each frequency count.

This function is a blunt tool designed for initial data checking. It is not
too informative if many values have few characters each.

For summary statistics, call \code{\link[=audit]{audit()}} on the results.
}
\section{Summaries with \code{\link[=audit]{audit()}}}{
 There is an S3 method for the
\code{\link[=audit]{audit()}} generic, so you can call \code{\link[=audit]{audit()}} following
\code{duplicate_count()}. It returns a tibble with summary statistics for the
two numeric columns, \code{frequency} and \code{locations_n} (or, if \code{x} isn't named,
only for \code{frequency}).
}

\examples{
# Count duplicate values...
iris \%>\%
  duplicate_count()

# ...and compute summaries:
iris \%>\%
  duplicate_count() \%>\%
  audit()

# Any values can be ignored:
iris \%>\%
  duplicate_count(ignore = c("setosa", "versicolor", "virginica"))
}
\seealso{
\itemize{
\item \code{\link[=duplicate_count_colpair]{duplicate_count_colpair()}} to check each combination of columns for
duplicates.
\item \code{\link[=duplicate_tally]{duplicate_tally()}} to show instances of a value next to each instance.
\item \code{\link[janitor:get_dupes]{janitor::get_dupes()}} to search for duplicate rows.
}
}
