% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xmile.R
\name{xmile}
\alias{xmile}
\title{Create a new stock-and-flow model}
\usage{
xmile(name = NULL)
}
\arguments{
\item{name}{Name of the template to load. If \code{NULL}, an empty stock-and-flow
model will be created with default simulation parameters and a default header.
If specified, \code{name} should be one of the available templates:
\itemize{
\item \strong{logistic_model}: Population growth with carrying capacity
\item \strong{SIR}: Epidemic model (Susceptible-Infected-Recovered)
\item \strong{predator_prey}: Lotka-Volterra dynamics
\item \strong{cusp}: Cusp catastrophe model
\item \strong{Crielaard2022}: Eating behavior (doi: 10.1037/met0000484)
\item \strong{coffee_cup}: Temperature equilibration (Meadows)
\item \strong{bank_account}: Compound interest (Meadows)
\item \strong{Lorenz}: Lorenz attractor (chaotic)
\item \strong{Rossler}: Rossler attractor (chaotic)
\item \strong{vanderPol}: Van der Pol oscillator
\item \strong{Duffing}: Forced Duffing oscillator
\item \strong{Chua}: Chua's circuit (chaotic)
\item \strong{JDR}: Job Demands-Resources Theory as formalized in Evers et al. (submitted)
}}
}
\value{
A stock-and-flow model object of class \code{\link[=xmile]{sdbuildR_xmile}}. Its structure is based
on \href{https://docs.oasis-open.org/xmile/xmile/v1.0/os/xmile-v1.0-os.html}{XML Interchange Language for System Dynamics (XMILE)}. It is a nested list, containing:
\describe{
\item{header}{Meta-information about model. A list containing arguments listed in \code{\link[=header]{header()}}.}
\item{sim_specs}{Simulation specifications. A list containing arguments listed in \code{\link[=sim_specs]{sim_specs()}}.}
\item{model}{Model variables, grouped under the variable types stock, flow, aux (auxiliaries), constant, and gf (graphical functions). Each variable contains arguments as listed in \code{\link[=build]{build()}}.}
\item{macro}{Global variable or functions. A list containing arguments listed in \code{\link[=macro]{macro()}}.}
\item{model_units}{Custom model units. A list containing arguments listed in \code{\link[=model_units]{model_units()}}.}
}

Use \code{\link[=summary]{summary()}} to summarize, \code{\link[=as.data.frame]{as.data.frame()}} to convert to a data.frame, \code{\link[=plot]{plot()}} to visualize.
}
\description{
Initialize a stock-and-flow model of class \code{\link[=xmile]{sdbuildR_xmile}}. You can
either create an empty stock-and-flow model or load a template from the model
library.
}
\details{
Do not edit the object manually; this will likely lead to errors downstream.
Rather, use \code{\link[=header]{header()}}, \code{\link[=sim_specs]{sim_specs()}}, \code{\link[=build]{build()}}, \code{\link[=macro]{macro()}}, and
\code{\link[=model_units]{model_units()}} for safe manipulation.
}
\examples{
sfm <- xmile()
summary(sfm)

\dontshow{
sfm <- sim_specs(sfm, save_at = 1)
}

# Load a template
sfm <- xmile("Lorenz")
sim <- simulate(sfm)
plot(sim)
}
\seealso{
\code{\link[=build]{build()}}, \code{\link[=header]{header()}}, \code{\link[=macro]{macro()}}, \code{\link[=model_units]{model_units()}}, \code{\link[=sim_specs]{sim_specs()}}
}
\concept{build}
