% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_app.R
\name{hier_app}
\alias{hier_app}
\title{Create/Modify hierarchies interactively}
\usage{
hier_app(x = hier_create(), ...)
}
\arguments{
\item{x}{a character vector containing nested levels or
an object generated with \code{\link[=hier_create]{hier_create()}}}

\item{...}{arguments (e.g \code{host}) that are passed
through \code{\link[shiny:runApp]{shiny::runApp()}} when
starting the shiny application}
}
\value{
The app can return a hierarchy object (either
a \code{data.frame} or a tree-based object)
}
\description{
This function starts the interactive \code{shiny}-app
to (optionally) create and/or modify a nested hierarchy.
It is possible to supply a character vector from which the
hierarchy can be interactively built. Once this has been done,
it is possible to modify and export the resulting hierarchy.
}
\details{
Another option is to supply an already existing hierarchy object.
In this case, it is possible to modify the existing object in
the app.
}
\examples{
\dontrun{
# start with an empty hierarchy
res <- hier_app()

# start with a character vector that is used to
build the hierarchy
codes <- c("11", "12", "21", "22", "23", "31", "32")
res <- hier_app(codes); print(res)
}
}
