% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotFunctions.R
\docType{methods}
\name{plot.sdcMicroObj}
\alias{plot}
\alias{plot,sdcMicroObj-method}
\alias{plot-methods}
\alias{plot.sdcMicroObj}
\title{Plotfunctions for objects of class \code{\link{sdcMicroObj-class}}}
\usage{
\S4method{plot}{sdcMicroObj}(x, type = "ls", ...)
}
\arguments{
\item{x}{An object of class \code{\link{sdcMicroObj-class}}}

\item{type}{specified what kind of plot will be generated
\itemize{
\item 'ls': plot of local suppressions in key variables
}}

\item{...}{currently ignored}
}
\description{
Descriptive plot function for Frequencies and local Supression, Recoding,
categorical risk and numerical risk.
}
\details{
Possible values for the type argument of the print function are: "freq": for
Frequencies, "ls": for Local Supression output, "pram": for results of
post-randomization "recode":for Recodes, "risk": forCategorical risk and
"numrisk": for Numerical risk.

Possible values for the type argument of the freq function are: "fk": Sample
frequencies and "Fk": weighted frequencies.
}
\examples{
data(testdata)
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof','walls','relat','sex'),
  pramVars=c('water','electcon'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- kAnon(sdc, k=5)
plot(sdc, type="ls")
}
\author{
Bernhard Meindl
}
\keyword{classes}

