% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGen.r
\docType{methods}
\name{dataGen}
\alias{dataGen}
\title{Fast generation of synthetic data}
\usage{
dataGen(obj, ...)
}
\arguments{
\item{obj}{an \code{\link{sdcMicroObj-class}}-object or a \code{data.frame}}

\item{...}{see possible arguments below
\itemize{
\item{n:}{ amount of observations for the generated data, defaults to 200}
\item{use:}{ howto compute covariances in case of missing values, see also argument \code{use} in \code{\link{cov}}.
The default choice is 'everything', other possible choices are 'all.obs', 'complete.obs', 'na.or.complete' or 'pairwise.complete.obs'.}}}
}
\value{
the generated synthetic data.
}
\description{
Fast generation of (primitive) synthetic multivariate normal data.
}
\details{
Uses the cholesky decomposition to generate synthetic data with approx. the
same means and covariances. For details see at the reference.
}
\note{
With this method only multivariate normal distributed data with
approxiomately the same covariance as the original data can be generated
without reflecting the distribution of real complex data, which are, in
general, not follows a multivariate normal distribution.
}
\examples{
data(mtcars)
cov(mtcars[,4:6])
cov(dataGen(mtcars[,4:6]))
pairs(mtcars[,4:6])
pairs(dataGen(mtcars[,4:6]))

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- dataGen(sdc)
}
\references{
Have a look at \doi{10.1007/978-3-540-25955-8_24}
}
\seealso{
\code{\link{sdcMicroObj-class}}, \code{\link{shuffle}}
}
\author{
Matthias Templ
}
\keyword{manip}
