% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInfo.R
\name{setInfo}
\alias{setInfo}
\title{set information of \code{\link{sdcProblem-class}}- or \code{\link{problemInstance-class}} objects}
\usage{
setInfo(object, type, index, input)
}
\arguments{
\item{object}{an object of class \code{\link{sdcProblem-class}} or \code{\link{problemInstance-class}}}

\item{type}{a character vector of length 1 specifying the the information that should be changed or modified, valid choices are:
\itemize{
\item \code{lb}: slot 'lb' of input \code{object} if it is of class \code{\link{problemInstance-class}} or slot 'lb' within slot 'problemInstance' if \code{object} is of class \code{\link{sdcProblem-class}}
\item \code{ub}: slot 'ub' of input \code{object} if it is of class \code{\link{problemInstance-class}} or slot 'ub' within slot 'problemInstance' if \code{object} is of class \code{\link{sdcProblem-class}}
\item \code{LPL}: slot 'LPL' of input \code{object} if it is of class \code{\link{problemInstance-class}} or slot 'LPL' within slot 'problemInstance' if \code{object} is of class \code{\link{sdcProblem-class}}
\item \code{SPL}: slot 'SPL' of input \code{object} if it is of class \code{\link{problemInstance-class}} or slot 'SPL' within slot 'problemInstance' if \code{object} is of class \code{\link{sdcProblem-class}}
\item \code{UPL}: slot 'UPL' of input \code{object} if it is of class \code{\link{problemInstance-class}} or slot 'UPL' within slot 'problemInstance' if \code{object} is of class \code{\link{sdcProblem-class}}
\item \code{sdcStatus}:  slot 'sdcStatus' of input \code{object} if it is of class \code{\link{problemInstance-class}} or slot 'sdcStatus' within slot 'problemInstance' if \code{object} is of class \code{\link{sdcProblem-class}} }}

\item{index}{numeric vector defining cell-indices for which which values in a specified slot should be changed|modified}

\item{input}{numeric or character vector depending on argument \code{type} with its length matching the length of argument \code{index}
\itemize{
\item character vector if type matches 'sdcStatus'
\item a numeric vector if type matches 'lb', 'ub', 'LPL', 'SPL' or 'UPL'
}}
}
\value{
a \code{\link{sdcProblem-class}}- or \code{\link{problemInstance-class}} object
}
\description{
Function \code{\link{getInfo}} is used to query information from
\code{\link{sdcProblem-class}}- or \code{\link{problemInstance-class}} objects
}
\examples{
# load primary suppressed data (created in the example of \code{\link{primarySuppression}})
sp <- searchpaths()
fn <- paste(sp[grep("sdcTable", sp)], "/data/problemWithSupps.RData", sep="")
problem <- get(load(fn))

# which is the overall total?
index.tot <- which.max(getInfo(problem, 'freq'))
index.tot

# we see that the cell with index.tot==1 is the overall total and its
# anonymization state of the total can be extracted as follows:
print(getInfo(problem, type='sdcStatus')[index.tot])

# we want this cell to never be suppressed
problem <- setInfo(problem, type='sdcStatus', index=index.tot, input='z')

# we can verify this:
print(getInfo(problem, type='sdcStatus')[index.tot])

# changing slot 'UPL' for all cells
inp <- data.frame(strID=getInfo(problem,'strID'), UPL_old=getInfo(problem,'UPL'))
inp$UPL_new <- inp$UPL_old+1
problem <- setInfo(problem, type='UPL', index=1:nrow(inp), input=inp$UPL_new)

}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
