% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{sdcHashingDefinitionClass-class}
\alias{initialize,sdcHashingDefinitionClass-method}
\alias{sdcHashingDefinitionClass-class}
\title{Hashing Definition (S4 Class)}
\usage{
\S4method{initialize}{sdcHashingDefinitionClass}(.Object, ...)
}
\arguments{
\item{.Object}{A \code{\linkS4class{sdcHashingDefinitionClass}} object.}

\item{...}{The optional parameters specifying the data
and whether \code{NA} values are to be recoded and hashed.
Recoding is \code{TRUE} by default.}
}
\description{
This class defines the data hash that is used to identify
  cells to be targeted for statistical disclosure control.
}
\details{
The hashing definition presently handles only categorical
  fields, which limits the applicability of this software
  accordingly.
}
\section{Methods (by generic)}{
\itemize{
\item \code{initialize}: 
}}
\section{Slots}{

\describe{
\item{\code{parts}}{The number of hashing components.}

\item{\code{coverage}}{The number of elements in each hashing component.}

\item{\code{lengths}}{The number of levels of each field to be hashed.}

\item{\code{na.exists}}{Whether there is an NA value in each field to be hashed.}

\item{\code{na.recode}}{Whether NA values should be treated as levels.}

\item{\code{levels}}{The number of levels of each field to be hashed.}
}}
\examples{
new("sdcHashingDefinitionClass")
new("sdcHashingDefinitionClass")
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
new("sdcHashingDefinitionClass", X = my.X)
new("sdcHashingDefinitionClass", X = my.X, na.recode = FALSE)
}

