% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pc-matern.R
\name{plot_pc_matern}
\alias{plot_pc_matern}
\title{Plot PC Matern priors}
\usage{
plot_pc_matern(
  range_gt,
  sigma_lt,
  range_prob = 0.05,
  sigma_prob = 0.05,
  range_lims = c(range_gt * 0.1, range_gt * 10),
  sigma_lims = c(0, sigma_lt * 2),
  plot = TRUE
)
}
\arguments{
\item{range_gt}{A value one expects the spatial or spatiotemporal range is
\strong{g}reater \strong{t}han with \code{1 - range_prob} probability.}

\item{sigma_lt}{A value one expects the spatial or spatiotemporal marginal
standard deviation (\code{sigma_O} or \code{sigma_E} internally) is \strong{l}ess \strong{t}han
with \code{1 - sigma_prob} probability.}

\item{range_prob}{Probability. See description for \code{range_gt}.}

\item{sigma_prob}{Probability. See description for \code{sigma_lt}.}

\item{range_lims}{Plot range variable limits.}

\item{sigma_lims}{Plot sigma variable limits.}

\item{plot}{Logical controlling whether plot is drawn (defaults to \code{TRUE}).}
}
\value{
A plot from \code{\link[=image]{image()}}.
Invisibly returns the underlying matrix data. The rows are the sigmas. The
columns are the ranges. Column and row names are provided.
}
\description{
Plot PC Matern priors
}
\examples{
plot_pc_matern(range_gt = 5, sigma_lt = 1)
plot_pc_matern(range_gt = 5, sigma_lt = 10)
plot_pc_matern(range_gt = 5, sigma_lt = 1, sigma_prob = 0.2)
plot_pc_matern(range_gt = 5, sigma_lt = 1, range_prob = 0.2)
}
\seealso{
\code{\link[=pc_matern]{pc_matern()}}
}
