% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{control}
\alias{control}
\title{Control Theory}
\usage{
control(B)
}
\arguments{
\item{B}{a matrix object containing square matrices of size n}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant C matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{control} creates input for sqlp to solve the Control Theory Problem
}
\details{
Solves the control theory problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
B <- matrix(list(),2,1)
B[[1]] <- matrix(c(-.8,1.2,-.5,-1.1,-1,-2.5,2,.2,-1),nrow=3,byrow=TRUE)
B[[2]] <- matrix(c(-1.5,.5,-2,1.1,-2,.2,-1.4,1.1,-1.5),nrow=3,byrow=TRUE)

out <- control(B)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

