% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpp.R
\name{gpp}
\alias{gpp}
\title{Graph Partitioning Problem}
\usage{
gpp(B, alpha)
}
\arguments{
\item{B}{A weighted adjacency matrix}

\item{alpha}{Any real value in (0,n^2)}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{gpp} creates input for sqlp to solve the graph partitioning problem.
}
\details{
Solves the graph partitioning problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Bgpp)
alpha <- nrow(Bgpp)

out <- gpp(Bgpp, alpha)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

