% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearestcorr.R
\name{nearcorr}
\alias{nearcorr}
\title{Nearest Correlation Matrix Problem}
\usage{
nearcorr(H)
}
\arguments{
\item{H}{A symmetric matrix}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{nearcorr} creates input for sqlp to solve the nearest correlation matrix problem -
given a approximate correlation matrix H, find the nearest correlation matrix X.
}
\details{
For a given approximate correlation matrix H, determines the nearest correlation matrix X. 
Mathematical and implementation details can be found in the vignette
}
\examples{
data(Hnearcorr)

out <- nearcorr(Hnearcorr)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

