% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdep_helpers.R
\name{spdep_distance_swm}
\alias{spdep_distance_swm}
\title{constructs spatial weight matrices based on distance}
\usage{
spdep_distance_swm(
  sfj,
  kernel = NULL,
  k = NULL,
  bandwidth = NULL,
  power = 1,
  style = "W",
  zero.policy = TRUE
)
}
\arguments{
\item{sfj}{An \code{sf} object or can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{kernel}{(optional) The kernel function, can be one of \code{uniform},
\code{triangular},\code{quadratic}(\code{epanechnikov}),\code{quartic} and \code{gaussian}. Default is \code{NULL}.}

\item{k}{(optional) The number of nearest neighbours. Default is \code{NULL}. Only useful
when \code{kernel} is provided.}

\item{bandwidth}{(optional) The bandwidth, default is \code{NULL}. When the spatial reference
of sf object is the geographical coordinate system, the unit of \code{bandwidth} is \code{km}. The
unit used in the projection coordinate system are consistent with those used in the sf
object coordinate system.}

\item{power}{(optional) Default is \code{1}. Useful when \code{kernel} is not provided.}

\item{style}{(optional) \code{style} can take values \code{W}, \code{B}, \code{C}, and \code{S}. More to see
\code{spdep::nb2mat()}. Default is \code{W}. For spatial weights based on distance functions,
a style of \code{B} means using the original value of the calculated distance function.}

\item{zero.policy}{(optional)  if \code{FALSE} stop with error for any empty neighbour sets,
if \code{TRUE} permit the weights list to be formed with zero-length weights vectors. Default
is \code{TRUE}.}
}
\value{
A matrix
}
\description{
Constructs spatial weight matrices based on distance via \code{spdep} package.
}
\details{
five different kernel weight functions:
\itemize{
\item uniform:
\eqn{K_{(z)} = 1/2},for \eqn{\lvert z \rvert < 1}
\item triangular
\eqn{K_{(z)} = 1 - \lvert z \rvert},for \eqn{\lvert z \rvert < 1}
\item quadratic (epanechnikov)
\eqn{K_{(z)} = \frac{3}{4} \left( 1 - z^2 \right)},for \eqn{\lvert z \rvert < 1}
\item quartic
\eqn{K_{(z)} = \frac{15}{16} {\left( 1 - z^2 \right)}^2},for \eqn{\lvert z \rvert < 1}
\item gaussian
\eqn{K_{(z)} = \frac{1}{\sqrt{2 \pi}} e^{- \frac{z^2}{2}}}
}

For the equation above, \eqn{z = d_{ij} / h_i}
where \eqn{h_i} is the bandwidth
}
\note{
When \code{kernel} is setting, using distance weight based on kernel function, Otherwise
the inverse distance weight will be used.
}
\examples{
library(sf)
pts = read_sf(system.file('extdata/pts.gpkg',package = 'sdsfun'))

wt1 = spdep_distance_swm(pts, style = 'B')
wt2 = spdep_distance_swm(pts, kernel = 'gaussian')
wt3 = spdep_distance_swm(pts, k = 3, kernel = 'gaussian')
wt4 = spdep_distance_swm(pts, k = 3, kernel = 'gaussian', bandwidth = 10000)

}
