% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdep_helpers.R
\name{spdep_nb}
\alias{spdep_nb}
\title{construct neighbours list}
\usage{
spdep_nb(sfj, queen = TRUE, k = NULL, order = 1L, cumulate = TRUE)
}
\arguments{
\item{sfj}{An \code{sf} object or can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{queen}{(optional) if \code{TRUE}, using queen contiguity, otherwise rook contiguity.
Default is \code{TRUE}.}

\item{k}{(optional) The number of nearest neighbours. Ignore this parameter when not
using distance based neighbours.}

\item{order}{(optional) The order of the adjacency object. Default is \code{1}.}

\item{cumulate}{(optional) Whether to accumulate adjacency objects. Default is \code{TRUE}.}
}
\value{
A neighbours list with class \code{nb}
}
\description{
construct neighbours list
}
\note{
When \code{k} is set to a positive value, using K-Nearest Neighbor
}
\examples{
library(sf)
pts = read_sf(system.file('extdata/pts.gpkg',package = 'sdsfun'))

nb1 = spdep_nb(pts, k = 6)
nb2 = spdep_nb(pts, queen = TRUE)
nb3 = spdep_nb(pts, queen = FALSE, order = 2)

}
