% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catchdata.R
\name{catchdata}
\alias{catchdata}
\title{Get catch data for a region as a dataframe or stacked area chart}
\usage{
catchdata(region, id, measure = "tonnage", dimension = "taxon",
  limit = 10, chart = FALSE, ...)
}
\arguments{
\item{region}{(character) region type. one of: eez, lme, rfmo, highseas,
fao, eez-bordering, fishing-entity, taxon, or global}

\item{id}{(character/integer/numeric) region id. depends on what
\code{region} is specified. See \code{\link{regions}} for details}

\item{measure}{(character) the data measurement. one of "tonnage" or "value"
(for "landed value"). Default: "tonnage"}

\item{dimension}{(character) dimension data is bucketed on. one of "taxon",
"commercialgroup", "functionalgroup", "country", "sector", "catchtype",
"reporting-status", "layer" (for "data layer"). Default: "taxon"}

\item{limit}{(numeric/integer) number of buckets of data plus one for
"others". Default: 10}

\item{chart}{(boolean) to return a chart versus a data frame
Default: \code{FALSE}}

\item{...}{curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
data frame (or ggplot2 chart) with catch data for the requested
region over time
}
\description{
Get catch data for a region as a dataframe or stacked area chart
}
\examples{
catchdata("eez", 76)
head(catchdata("eez", 76, measure="value", dimension="reporting-status"))
catchdata("eez", 76, measure="value", dimension="sector")
catchdata("eez", 76, measure="value", dimension="taxon")
\dontrun{
catchdata(region = "eez", id = 76, chart = TRUE)
}
}
