% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getData.R
\name{fix_sample_url}
\alias{fix_sample_url}
\title{Mark As Fixed the individual sample URLs}
\usage{
fix_sample_url(siteURL, pageURL, category = "notFound", platform = "web")
}
\arguments{
\item{siteURL}{The URL of the website to delete. Must include protocol (http://).}

\item{pageURL}{A PageUrl taken from list_crawl_error_samples.}

\item{category}{Crawl error category. Default 'notFound'.}

\item{platform}{User agent type. Default 'web'.}
}
\value{
TRUE if successful, raises an error if not.
}
\description{
pageURL is the relative path (without the site) of the sample URL.
It must be one of the URLs returned by list_crawl_error_samples.
For example, for the URL https://www.example.com/pagename on the site https://www.example.com/,
the url value is pagename (string)

Category is one of: authPermissions, manyToOneRedirect, notFollowed, notFound,
  other, roboted, serverError, soft404.

  Platform is one of: mobile, smartphoneOnly or web.
}
\details{
See here for details:
https://developers.google.com/webmaster-tools/v3/urlcrawlerrorssamples/markAsFixed
}
\seealso{
Other working with search console errors: \code{\link{crawl_errors}};
  \code{\link{error_sample_url}};
  \code{\link{list_crawl_error_samples}}
}

