% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.parameters_pca.R
\name{plot.see_parameters_pca}
\alias{plot.see_parameters_pca}
\title{Plot method for principal component analysis}
\usage{
\method{plot}{see_parameters_pca}(
  x,
  type = c("bar", "line"),
  text_size = 3.5,
  text_color = "black",
  size = 1,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{type}{Character vector, indicating the type of plot.}

\item{text_size}{Size of text labels.}

\item{text_color}{Color of text labels.}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::principal_components()} function.
}
\examples{
library(parameters)
data(mtcars)
result <- principal_components(mtcars[, 1:7], n = "all", threshold = 0.2)
result
plot(result)
}
