% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.point_estimates.R
\name{plot.see_point_estimate}
\alias{plot.see_point_estimate}
\title{Plot method for point estimates of posterior samples}
\usage{
\method{plot}{see_point_estimate}(
  x,
  data = NULL,
  size_point = 2,
  size_text = 3.5,
  panel = TRUE,
  show_labels = TRUE,
  show_intercept = FALSE,
  priors = FALSE,
  priors_alpha = 0.4,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{panel}{Logical, if \code{TRUE}, plots are arranged as panels; else,
single plots are returned.}

\item{show_labels}{Logical. If \code{TRUE}, the text labels for the point
estimates (i.e. \emph{"Mean"}, \emph{"Median"} and/or \emph{"MAP"}) are
shown. You may set \code{show_labels = FALSE} in case of overlapping
labels, and add your own legend or footnote to the plot.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{priors}{Logical. If \code{TRUE}, prior distributions are simulated
(using \code{\link[bayestestR:simulate_prior]{bayestestR::simulate_prior()}}) and added
to the plot.}

\item{priors_alpha}{Numeric value specifying alpha for the prior
distributions.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::point_estimate()}.
}
\examples{
\dontshow{if (require("rstanarm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(rstanarm)
library(bayestestR)
set.seed(123)
m <<- stan_glm(Sepal.Length ~ Petal.Width * Species, data = iris, refresh = 0)
result <- point_estimate(m, centrality = "median")
result
plot(result)
}
\dontshow{\}) # examplesIf}
}
