% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqlda.R
\name{textmodel_seqlda}
\alias{textmodel_seqlda}
\title{Sequential Latent Dirichlet allocation}
\usage{
textmodel_seqlda(
  x,
  k = 10,
  max_iter = 2000,
  alpha = 0.5,
  beta = 0.1,
  model = NULL,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{the dfm on which the model will be fit.}

\item{k}{the number of topics.}

\item{max_iter}{the maximum number of iteration in Gibbs sampling.}

\item{alpha}{the value to smooth topic-document distribution.}

\item{beta}{the value to smooth topic-word distribution.}

\item{model}{a fitted LDA model; if provided, \code{textmodel_lda()} inherits
parameters from an existing model. See details.}

\item{verbose}{logical; if \code{TRUE} print diagnostic information during
fitting.}
}
\description{
Implements Sequential Latent Dirichlet allocation (Sequential LDA).
\code{textmodel_seqlda()} allows the users to classify sentences of texts. It
considers the topics of previous document in inferring the topics of currency
document. \code{textmodel_seqlda()} is a shortcut equivalent to
\code{textmodel_lda(gamma = 0.5)}. Seeded Sequential LDA is
\code{textmodel_seededlda(gamma = 0.5)}.
}
\references{
Du, Lan et al. (2012). "Sequential Latent Dirichlet Allocation".
doi.org/10.1007/s10115-011-0425-1. \emph{Knowledge and Information Systems}.

Watanabe, Kohei & Baturo, Alexander. (forthcoming). "Seeded Sequential LDA: A
Semi-supervised Algorithm for Topic-specific Analysis of Sentences".
\emph{Social Science Computer Review}.
}
