% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garch.seg.R
\docType{methods}
\name{garch.seg-class}
\alias{garch.seg-class}
\alias{garch.seg}
\alias{garch.seg-methods}
\alias{garch.seg,ANY-method}
\alias{garch.seg,tvMGarch-method}
\title{An S4 method to detect the change-points in a high-dimensional GARCH process.}
\usage{
garch.seg(object, x, p = 1, q = 0, f = NULL, sig.level = 0.05,
  Bsim = 200, off.diag = TRUE, dw = NULL, do.pp = TRUE,
  do.parallel = 4)

\S4method{garch.seg}{ANY}(object = NULL, x, p = 1, q = 0, f = NULL,
  sig.level = 0.05, Bsim = 200, off.diag = TRUE, dw = NULL,
  do.pp = TRUE, do.parallel = 4)

\S4method{garch.seg}{tvMGarch}(object, p = 1, q = 0, f = NULL,
  sig.level = 0.05, Bsim = 200, off.diag = TRUE, dw = NULL,
  do.pp = TRUE, do.parallel = 4)
}
\arguments{
\item{object}{A \code{tvMGarch} object. Not necessary if \code{x} is used.}

\item{x}{Input data matrix, with each row representing the component time series.}

\item{p}{Choose the ARCH order. Default is 1.}

\item{q}{Choose the GARCH order. Default is 0.}

\item{f}{The dampening factor. If NULL then \code{f} is selected automatically. Default is NULL.}

\item{sig.level}{Indicates the quantile of bootstrap test statistics to be used for threshold selection. Default is 0.05.}

\item{Bsim}{Number of bootstrap samples for threshold selection. Default is 200.}

\item{off.diag}{If \code{TRUE} allows to look at the cross-sectional correlation structure.}

\item{dw}{The length of boundaries to be trimmed off.}

\item{do.pp}{Allows further post processing of the estimated change-points to reduce the risk of undersegmentation.}

\item{do.parallel}{Number of copies of R running in parallel, if \code{do.parallel = 0}, \%do\% operator is used, see also \link{foreach}.}
}
\description{
An S4 method to detect the change-points in a high-dimensional GARCH process using the DCBS methodology described in Cho and Korkas (2018). If a \code{tvMGarch} is specified then it returns a \code{tvMGarch} object is returned. Otherwise a list of features is returned.
}
\examples{
#pw.CCC.obj <- new("simMGarch")
#pw.CCC.obj@d=10
#pw.CCC.obj@n=1000
#pw.CCC.obj@changepoints=c(250,750)
#pw.CCC.obj <- pc_cccsim(pw.CCC.obj)
#dcs.obj=garch.seg(x=empirObj@y,do.parallel = 4)
}
\references{
Cho, Haeran, and Karolos Korkas. "High-dimensional GARCH process segmentation with an application to Value-at-Risk." arXiv preprint arXiv:1706.01155 (2018).
}
