% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postHoc.R
\name{semPower.postHoc}
\alias{semPower.postHoc}
\title{semPower.postHoc}
\usage{
semPower.postHoc(effect = NULL, effect.measure = NULL, alpha, N, df,
  p = NULL, SigmaHat = NULL, Sigma = NULL)
}
\arguments{
\item{effect}{effect size specifying the discrepancy between H0 and H1}

\item{effect.measure}{type of effect, one of "F0", "RMSEA", "Mc", "GFI", AGFI"}

\item{alpha}{alpha error}

\item{N}{the number of observations}

\item{df}{the model degrees of freedom}

\item{p}{the number of observed variables, required for effect.measure = "GammaHat", "GFI",  and "AGFI"}

\item{SigmaHat}{model implied covariance matrix. Use in conjuntion with Sigma to define effect and effect.measure.}

\item{Sigma}{population covariance matrix. Use in conjuntion with SigmaHat to define effect and effect.measure.}
}
\value{
list
}
\description{
Determine power (1-beta) given alpha, df, and effect
}
\examples{
\dontrun{
power <- semPower.postHoc(effect = .05, effect.measure = "RMSEA", alpha = .05, N = 250, df = 200)
power
power <- semPower.postHoc(N = 1000, df = 5, alpha = .05,  
                          SigmaHat = diag(4), Sigma = cov(matrix(rnorm(4*1000),  ncol=4)))
power
}
}
