% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_i_one.R
\name{ci_i_one}
\alias{ci_i_one}
\title{Likelihood-Based Confidence Bound for One Parameter}
\usage{
ci_i_one(
  i,
  which = NULL,
  sem_out,
  method = "wn",
  standardized = FALSE,
  robust = "none",
  sf_full = NA,
  sf_args = list(),
  sem_out_name = NULL,
  try_k_more_times = 0,
  ...
)
}
\arguments{
\item{i}{The position (row number) of the target parameters as
appeared in the parameter table of the \link[lavaan:lavaan-class]{lavaan::lavaan}
object.}

\item{which}{Whether the lower bound or the upper bound is to be
found. Must be \code{"lbound"} or \code{"ubound"}.}

\item{sem_out}{The SEM output. Currently supports
\link[lavaan:lavaan-class]{lavaan::lavaan} outputs only.}

\item{method}{The approach to be used. Default is \code{"wn"}
(Wu-Neale-2012 Method), the only supported method.}

\item{standardized}{Logical. Whether the bound of the LBCI of the
standardized solution is to be searched. Default is \code{FALSE}.}

\item{robust}{Whether the LBCI based on robust likelihood ratio
test is to be found. Only \code{"satorra.2000"} in
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} is supported for now. If `"none"``, the
default, then likelihood ratio test based on maximum likelihood
estimation will be used.}

\item{sf_full}{A list with the scaling and shift factors. Ignored
if \code{robust} is \code{"none"}. If \code{robust} is \code{"satorra.2000"} and
\code{sf_full} is supplied, then its value will be used. If \code{robust} is
\code{"satorra.2000"} but \code{sf_full} is \code{NA}, then scaling factors will
be computed internally.}

\item{sf_args}{The list of arguments to be used for computing scaling factors
if \code{robust} is \code{"satorra.2000"}. Used only by \code{\link[=semlbci]{semlbci()}}. Ignored
if \code{robust} is not \code{"satorra.2000"}.}

\item{sem_out_name}{The name of the object supplied to \code{sem_out}. \code{NULL}
by default. Originally used by some internal functions. No longer used
in the current version but kept for backward compatibility.}

\item{try_k_more_times}{How many more times to try if the status
code is not zero. Default is 0.}

\item{...}{Arguments to be passed to the function corresponds to
the requested method (\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}} for "wn").}
}
\value{
A list of the following elements.
\itemize{
\item \code{bound}: The bound located. \code{NA} if the search failed.
\item \code{diags}: Diagnostic information.
\item \code{method}: Method used. Currently only \code{"wn"} is the only possible
value.
\item \code{times}: Total time used in the search.
\item \code{sf_full}: The scaling and shift factors used.
\item \code{ci_bound_i_out}: The original output from \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}.
\item \code{attempt_lb_var}: How many attempts used to reduce the lower
bounds of free variances.
\item \code{attempt_more_times}: How many additional attempts used to search
for the bounds. Controlled by
\code{try_k_more_times}.
}
}
\description{
Find the likelihood-based confidence bound
for one parameter.
}
\details{
\subsection{Important Notice}{

This function is not supposed to be used directly by users in
typical scenarios. Its interface is user-\emph{unfriendly} because it
should be used through \code{\link[=semlbci]{semlbci()}}. It is exported such that
interested users can examine how a confidence bound is found, or
use it for experiments or simulations.
}

\subsection{Usage}{

\code{\link[=ci_i_one]{ci_i_one()}} is the link between \code{\link[=semlbci]{semlbci()}} and the lowest level
function (currently \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}). When called by \code{\link[=semlbci]{semlbci()}}
to find the bound of a parameter, \code{\link[=ci_i_one]{ci_i_one()}} calls a function
(\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}} by default) one or more times to find the bound
(limit) for a likelihood-based confidence interval.
}
}
\examples{

data(simple_med)

library(lavaan)
mod <-
"
m ~ x
y ~ m
"
fit_med <- lavaan::sem(mod, simple_med, fixed.x = FALSE)

parameterTable(fit_med)

# Find the LBCI for the first parameter
# The method "wn" needs the constraint function.
# Use set_constraint() to generate this function:
fn_constr0 <- set_constraint(fit_med)

# Call ci_i to find the bound, the lower bound in this example.
# The constraint function, assigned to f_constr, is passed
# to ci_bound_wn_i().
# npar is an argument for ci_bound_wn_i().
out <- ci_i_one(i = 1,
                which = "lbound",
                sem_out = fit_med,
                npar = 5,
                f_constr = fn_constr0)
out$bounds

}
\seealso{
\code{\link[=semlbci]{semlbci()}}, \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}
}
