% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-methods.R
\name{summary.semmccistd}
\alias{summary.semmccistd}
\title{Summary Method for an Object of Class \code{semmccistd}}
\usage{
\method{summary}{semmccistd}(object, digits = 4, ...)
}
\arguments{
\item{object}{Object of class \code{semmccistd}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of estimates, standard errors, number of Monte Carlo replications, and confidence intervals.
}
\description{
Summary Method for an Object of Class \code{semmccistd}
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
x <- rnorm(n = n)
m <- 0.50 * x + rnorm(n = n)
y <- 0.25 * x + 0.50 * m + rnorm(n = n)
data <- data.frame(x, m, y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  y ~ cp * x + b * m
  m ~ a * x
  ab := a * b
"
fit <- sem(data = data, model = model, fixed.x = FALSE)

# Monte Carlo --------------------------------------------------------------
unstd <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)

# Standardized Monte Carlo -------------------------------------------------
std <- MCStd(unstd)
summary(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{method}
