% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/sense.R
\docType{package}
\name{sense}
\alias{sense}
\alias{sense-package}
\title{sense}
\usage{
sense(
  df,
  target_feat,
  benchmarking = "all",
  super = "avg",
  algos = c("glmnet", "ranger", "xgboost", "rpart", "kknn", "svm"),
  sampling_rate = 1,
  metric = "mae",
  collapse_char_to = 10,
  num_preproc = "scale",
  fct_preproc = "one-hot",
  impute_num = "sample",
  missing_fusion = FALSE,
  inner = "holdout",
  outer = "holdout",
  folds = 3,
  repeats = 3,
  ratio = 0.5,
  selected_filter = "information_gain",
  selected_n_feats = NULL,
  tuning = "random_search",
  budget = 30,
  resolution = 5,
  n_evals = 30,
  minute_time = 10,
  patience = 0.3,
  min_improve = 0.01,
  java_mem = 64,
  decimals = 2,
  seed = 42
)
}
\arguments{
\item{df}{A data frame with features and target.}

\item{target_feat}{String. Name of the numeric feature for the regression task.}

\item{benchmarking}{Positive integer. Number of base learners to stack. Default: "all".}

\item{super}{String. Super learner of choice among the available learners. Default: "avg".}

\item{algos}{String vector. Available learners are: "glmnet", "ranger", "xgboost", "rpart", "kknn", "svm".}

\item{sampling_rate}{Positive numeric. Sampling rate before applying the stacked ensemble. Default: 1.}

\item{metric}{String. Evaluation metric for outer and inner cross-validation. Default: "mae".}

\item{collapse_char_to}{Positive integer. Conversion of characters to  factors with predefined maximum number of levels. Default: 10.}

\item{num_preproc}{String. Options for scalar pre-processing: "scale" or "range". Default: "scale".}

\item{fct_preproc}{String. Options for factor pre-processing: "encodeimpact", "encodelmer", "one-hot", "treatment", "poly", "sum", "helmert". Default: "one-hot".}

\item{impute_num}{String. Options for missing imputation in case of numeric: "sample" or "hist". Default: "sample". For factor the default mode is Out-Of-Range.}

\item{missing_fusion}{String. Adding missing indicator features. Default: "FALSE".}

\item{inner}{String. Cross-validation inner cycle: "holdout", "cv", "repeated_cv", "subsampling". Default: "holdout".}

\item{outer}{String. Cross-validation outer cycle: "holdout", "cv", "repeated_cv", "subsampling". Default: "holdout".}

\item{folds}{Positive integer. Number of repetitions used in "cv" and "repeated_cv". Default: 3.}

\item{repeats}{Positive integer. Number of repetitions used in "subsampling" and "repeated_cv". Default: 3.}

\item{ratio}{Positive numeric. Percentage value for "holdout" and "subsampling". Default: 0.5.}

\item{selected_filter}{String. Filters available for regression tasks: "carscore", "cmim", "correlation", "find_correlation", "information_gain", "relief", "variance". Default: "information_gain".}

\item{selected_n_feats}{Positive integer. Number of features to select through the chosen filter. Default: NULL.}

\item{tuning}{String. Available options are "random_search" and "grid_search". Default: "random_search".}

\item{budget}{Positive integer. Maximum number of trials during random search. Default: 30.}

\item{resolution}{Positive integer. Grid resolution for each hyper-parameter. Default: 5.}

\item{n_evals}{Positive integer. Number of evaluation for termination. Default: 30.}

\item{minute_time}{Positive integer. Maximum run time before termination. Default: 10.}

\item{patience}{Positive numeric. Percentage of stagnating evaluations before termination. Default: 0.3.}

\item{min_improve}{Positive numeric. Minimum error improvement required before termination. Default: 0.01.}

\item{java_mem}{Positive integer. Memory allocated to Java. Default: 64.}

\item{decimals}{Positive integer. Decimal format of prediction. Default: 2.}

\item{seed}{Positive integer. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item benchmark_error: comparison between the base learners
\item resampled_model: mlr3 standard description of the analytic pipeline.
\item plot: mlr3 standard graph of the analytic pipeline.
\item selected_n_feats: selected features and score according to the filtering method used.
\item model_error: error measure for outer cycle of cross-validation.
\item testing_frame: data set used for calculating the test metrics.
\item test_metrics: metrics reported are mse, rmse, mae, mape, mdae, rae, rse, rrse, smape.
\item model_predict: prediction function to apply to new data on the same scheme.
\item time_log: computation time.
}
}
\description{
Stacked ensamble for regression tasks based on 'mlr3' framework.
}
\examples{
\dontrun{
sense(benchmark, "y", algos = c("glmnet", "rpart"))

}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3.mlr-org.com/}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
