% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqQuickLook.R
\name{seqQuickLook}
\alias{seqQuickLook}
\title{Numbering NAs and types of gaps among a dataset}
\usage{
seqQuickLook(OD, np = 1, nf = 0)
}
\arguments{
\item{OD}{\code{matrix} object containing sequences of a variable with missing data (coded as \code{NA}).}

\item{np}{\code{numeric} object corresponding to the number of previous observations in the imputation model of the internal gaps (default \code{1}).}

\item{nf}{\code{numeric} object corresponding to the number of future observations in the imputation model of the internal gaps (default \code{0}).}
}
\value{
It returns a  \code{data.frame} object that summarizes for each type of gaps 
(Internal Gaps, Initial Gaps, Terminal Gaps, LEFT-
hand side SLG, RIGHT-hand side SLG, Both-hand side SLG),
the minimum length, the maximum length, the total number of gaps and 
the total number of NAs induced.
}
\description{
\code{seqQuickLook.R} is a function aimed at providing an overview of the
number and size of the different types of gaps
spread in the original dataset \code{OD}.
}
\examples{
data(OD)

seqQuickLook(OD=OD, np=1, nf=0)

}
\author{
Andre Berchtold <andre.berchtold@unil.ch>
}
