% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{tabix.read.table}
\alias{tabix.read.table}
\title{Read tabix file, similar to running tabix in command line.}
\usage{
tabix.read.table(tabixFile, tabixRange, col.names = TRUE,
  stringsAsFactors = FALSE)
}
\arguments{
\item{tabixFile}{character, an tabix indexed file}

\item{tabixRange}{character, a text indicating which range in the VCF file to extract. e.g. 1:100-200}

\item{col.names}{logical, use tabix file header as result headers (default: TRUE)}

\item{stringsAsFactors}{logical, store loaded data as factors (default: FALSE)}
}
\value{
data frame, each elements is an individual line
}
\description{
Read tabix file, similar to running tabix in command line.
}
\examples{
fileName = system.file("vcf/all.anno.filtered.extract.vcf.gz", package = "seqminer")
snp <- tabix.read.table(fileName, "1:196623337-196632470")
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
