% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeqListSummary.R
\name{SummarySeq}
\alias{SummarySeq}
\title{Summarise Sequoia Output or Pedigree}
\usage{
SummarySeq(
  SeqList = NULL,
  Pedigree = NULL,
  DumPrefix = c("F0", "M0"),
  SNPd = NULL,
  Plot = TRUE,
  Panels = "all"
)
}
\arguments{
\item{SeqList}{the list returned by \code{\link{sequoia}}. Only elements
'Pedigree' or 'PedigreePar' and 'AgePriors' are used. All ids in
'PedigreePar', and only those, are presumed genotyped.}

\item{Pedigree}{dataframe, pedigree with the first three columns being id -
dam - sire. Column names are ignored, as are additional columns, except for
columns OHdam, OHsire, MEpair, LLRdam, LLRsire, LLRpair (plotting only).}

\item{DumPrefix}{character vector of length 2 with prefixes for dummy dams
(mothers) and sires (fathers). Will be read from \code{SeqList}'s 'Specs'
if provided. Used to distinguish between dummies and non-dummies. Length 3
in case of hermaphrodites.}

\item{SNPd}{character vector with ids of SNP genotyped individuals. Only used
when \code{Pedigree} is provided instead of \code{SeqList}, to distinguish
between genetically assigned parents and 'observed' parents (e.g. observed
in the field, or assigned previously using microsatellites). If \code{NULL}
(the default), all parents are presumed observed.}

\item{Plot}{show barplots and histograms of the results, as well as of the
parental LLRs, Mendelian errors, and agepriors, if present.}

\item{Panels}{character vector with panel(s) to plot. Choose from 'all',
'G.parents' (parents of genotyped individuals), 'D.parents' (parents of
dummy individuals), 'sibships' (distribution of sibship sizes), 'LLR'
(log10-likelihood ratio parent/otherwise related), 'OH' (count of opposite
homozygote SNPs).}
}
\value{
A list with the following elements:
  \item{PedSummary}{a 2-column matrix with basic summary statistics, similar
  to what used to be returned by \pkg{Pedantics}' \code{pedStatSummary} (now
  archived on CRAN). First column refers to the complete pedigree, second
  column to SNP-genotyped individuals only. Maternal siblings sharing a dummy
  parent are counted in the 2nd column if both sibs are genotyped, but not if
  one of the sibs is a dummy individual.}
  \item{ParentCount}{an array with the number of assigned parents,
  split by:
  \itemize{
    \item offspringCat: Genotyped, Dummy, or Observed* (*: only when
    \code{Pedigree} is provided rather than \code{SeqList}, for ids which
    are not listed in \code{SNPd} and do not conform to \code{DumPrefix} +
    number (i.e. (almost) al individuals when \code{SNPd = NULL}, the
    default).
    \item offspringSex: Female, Male, Unknown, or Herm* (*: hermaphrodite,
    only if any individuals occur as both dam and sire). Based only on
    whether an individual occurs as Dam or Sire.
    \item parentSex: Dam or Sire
    \item parentCat: Genotyped, Dummy, Observed*, or None (*: as for
    offspringCat)
  }}
  \item{GPCount}{an array with the number of assigned grandparents,
  split by:
  \itemize{
    \item offspringCat: Genotyped, Dummy, Observed*, or All
    \item grandparent kind: maternal grandmothers (MGM),
  maternal grandfathers (MGF), paternal grandmothers (PGM), paternal
  grandfathers (PGF)
    \item grandparentCat: Genotyped, Dummy, Observed*, or None
    }}
  \item{SibSize}{a list with elements 'mat' (maternal half + full siblings),
  'pat' (paternal half + full siblings), and 'full' (full siblings). Each
  is a matrix with a number of rows equal to the maximum sibship size, and 3
  columns, splitting by the type of parent: Genotyped, Dummy, or Observed.}
}
\description{
Number of assigned parents and grandparents and sibship sizes,
  split by genotyped, dummy, and 'observed'.
}
\examples{
SummarySeq(Ped_griffin)
sumry_grif <- SummarySeq(SeqOUT_griffin, Panels=c("G.parents", "OH"))
sumry_grif$PedSummary

}
\seealso{
\code{\link{PlotSeqSum}} to plot the output of this function;
 \code{\link{sequoia}} for pedigree reconstruction and links to other
  functions.
}
