% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequoia_F90wrappers.R
\name{SeqParSib}
\alias{SeqParSib}
\title{Fortran Wrapper for Pedigree Reconstruction}
\usage{
SeqParSib(
  ParSib,
  FortPARAM,
  GenoM,
  LhIN,
  AgePriors,
  Parents,
  mtDif,
  DumPfx,
  quiet
)
}
\arguments{
\item{ParSib}{either "par" to call parentage assignment, or "sib" to call the
rest of the algorithm.}

\item{FortPARAM}{a named vector with parameter values, as generated by
\code{ParamToSpecs}.}

\item{GenoM}{matrix with genotype data, size nInd x nSnp.}

\item{LhIN}{life history data: ID - sex - birth year.}

\item{AgePriors}{matrix with agepriors, size `FortPARAM["nAgeClasses"]` by 8.}

\item{Parents}{matrix with rownumbers of assigned parents, size nInd by 2.}

\item{mtDif}{matrix indicating whether individuals have definitely a
different mitochondrial haplotype (1), or (possibly) the same (0). Size
nInd x nInd.}

\item{DumPfx}{dummy prefixes}

\item{quiet}{suppress messages.}
}
\value{
A list with
\item{PedigreePar or Pedigree}{the pedigree}
\item{DummyIDs}{Info on dummies (not included if parentage-only)}
\item{TotLikParents or TotLikSib}{Total log-likelihood per iteration}
\item{AgePriorExtra}{Ageprior including columns for grandparental and
  avuncular relationships}
\item{LifeHistPar or LifeHistSib}{Includes sex and birthyear estimate
  inferred from the pedigree for individuals with initially unknown sex
  and/or birthyear}.

For a detailed description of the output see \code{\link{sequoia}}.
}
\description{
Call main Fortran part of sequoia, and convert its output to a
  list with dataframes.
}
\keyword{internal}
