% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.summary.seroincidence.by.R
\name{autoplot.summary.seroincidence.by}
\alias{autoplot.summary.seroincidence.by}
\title{Plot method for \code{summary.seroincidence.by} objects}
\usage{
\method{autoplot}{summary.seroincidence.by}(object, xvar, alpha = 0.7, shape = 1, width = 0.001, ...)
}
\arguments{
\item{object}{a \code{summary.seroincidence.by} object (generated by applying the \code{summary()} method to the output of \code{\link[=est.incidence.by]{est.incidence.by()}}).}

\item{xvar}{the name of a stratifying variable in \code{object}}

\item{alpha}{transparency for the points in the graph (1 = no transparency, 0 = fully transparent)}

\item{shape}{shape argument for \code{geom_point()}}

\item{width}{width for jitter}

\item{...}{unused}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Plot method for \code{summary.seroincidence.by} objects
}
\examples{

library(dplyr)
library(ggplot2)

\donttest{
xs_data <- load_pop_data("https://osf.io/download//n6cp3/") \%>\%
  clean_pop_data()

curve <- load_curve_params("https://osf.io/download/rtw5k/") \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG")) \%>\%
  slice(1:100, .by = antigen_iso) # Reduce dataset for the purposes of this example

noise <- load_noise_params("https://osf.io/download//hqy4v/")

est2 <- est.incidence.by(
  strata = c("catchment"),
  pop_data = xs_data \%>\% filter(Country == "Pakistan"),
  curve_params = curve,
  noise_params = noise \%>\% filter(Country == "Pakistan"),
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  #num_cores = 8 #Allow for parallel processing to decrease run time
)

est2sum <- summary(est2)

autoplot(est2sum, "catchment")
}
}
