% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dev.r
\name{f_dev}
\alias{f_dev}
\title{Calculate negative log-likelihood (deviance) for one antigen:isotype pair}
\usage{
f_dev(lambda, csdata, lnpars, cond)
}
\arguments{
\item{lambda}{\code{\link[=numeric]{numeric()}} incidence parameter, in events per person-year}

\item{csdata}{cross-sectional sample data containing variables \code{value} and \code{age}}

\item{lnpars}{longitudinal antibody decay model parameters \code{alpha}, \code{y1}, and \code{d}}

\item{cond}{measurement noise parameters \code{nu}, \code{eps}, \code{y.low}, and \code{y.high}}
}
\value{
a \code{\link[=numeric]{numeric()}} vector of negative log-likelihoods,
corresponding to the elements of input \code{lambda}
}
\description{
more description to be added here
}
\examples{
\donttest{
library(dplyr)
library(tibble)

# load in longitudinal parameters
curve_params = load_curve_params("https://osf.io/download/rtw5k")
xs_data <- "https://osf.io/download//n6cp3/" \%>\%
load_pop_data() \%>\%
clean_pop_data()

#Load noise params
noise_params <- tibble(
  antigen_iso = c("HlyE_IgG", "HlyE_IgA"),
  nu = c(0.5, 0.5),                          # Biologic noise (nu)
  eps = c(0, 0),                             # M noise (eps)
  y.low = c(1, 1),                           # low cutoff (llod)
  y.high = c(5e6, 5e6))                      # high cutoff (y.high)

cur_antibody = "HlyE_IgA"

cur_data =
  xs_data \%>\%
  dplyr::filter(
   .data$catchment == "dhaka",
   .data$antigen_iso == cur_antibody)

cur_curve_params =
  curve_params \%>\%
  dplyr::filter(.data$antigen_iso == cur_antibody)

cur_noise_params =
  noise_params \%>\%
  dplyr::filter(.data$antigen_iso == cur_antibody)

if(!is.element('d', names(cur_curve_params)))
{
  cur_curve_params =
    cur_curve_params \%>\%
    dplyr::mutate(
      alpha = .data$alpha * 365.25,
      d = .data$r - 1)
}

lambda = seq(.1, .2, by = .01)
nll <- f_dev(
    lambda = lambda,
    csdata = cur_data,
    lnpars = cur_curve_params,
    cond = cur_noise_params
  )
}
}
\keyword{internal}
