% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_pop_data.R
\name{load_pop_data}
\alias{load_pop_data}
\title{Load a cross-sectional antibody survey data set}
\usage{
load_pop_data(file_path, antigen_isos = NULL)
}
\arguments{
\item{file_path}{path to an RDS file containing a cross-sectional antibody survey data set, stored as a \code{\link[=data.frame]{data.frame()}} or \link[tibble:tbl_df-class]{tibble::tbl_df}}

\item{antigen_isos}{\code{\link[=character]{character()}} vector of antigen isotypes to be used in analyses}
}
\value{
a \code{pop_data} object (a \link[tibble:tbl_df-class]{tibble::tbl_df} with extra attribute \code{antigen_isos})
}
\description{
Load a cross-sectional antibody survey data set
}
\examples{
xs_data <- load_pop_data("https://osf.io/download//n6cp3/")

print(xs_data)


}
