% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hbv_ru_1999}
\alias{hbv_ru_1999}
\title{Hepatitis B serological data from Russia in 1999 (aggregated)}
\format{
A data frame with 4 variables:
\describe{
 \item{age}{Age group}
 \item{pos}{Number of seropositive individuals}
 \item{tot}{Total number of individuals surveyed}
 \item{gender}{Gender of cohort (unsure what 1 and 2 means)}
}
}
\source{
Mukomolov, S., L. Shliakhtenko, I. Levakova, and E. Shargorodskaya.
Viral hepatitis in Russian federation. An analytical overview. Technical
Report 213 (3), 3rd edn. St Petersburg Pasteur Institute,
St Petersburg, 2000.
}
\usage{
hbv_ru_1999
}
\description{
A seroprevalence study conducted in St. Petersburg
(more information in the book)
}
\examples{
# Reproduce Fig 4.2, p. 65
library(dplyr)
hbv_ru_1999$age <- trunc(hbv_ru_1999$age / 1) * 1
hbv_ru_1999$age[hbv_ru_1999$age > 40] <- trunc(
  hbv_ru_1999$age[hbv_ru_1999$age > 40] / 5
) * 5
df <- hbv_ru_1999 \%>\%
  group_by(age) \%>\%
  summarise(pos = sum(pos), tot = sum(tot))
plot(
  df$age, df$pos / df$tot,
  cex = 0.05 * df$tot, pch = 16, xlab = "age",
  ylab = "seroprevalence", xlim = c(0, 72)
)

}
\keyword{datasets}
