% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_stats}
\alias{sst_sa_stats}
\title{Get the number of API rows left}
\usage{
sst_sa_stats(api_token)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}
}
\value{
Returns a number of API rows left. Also returns some additional
  information about user and
  \href{https://serpstat.com/extension/}{Serpstat plugin} limits.
}
\description{
With most API request you spend some amount of API rows. The total amount of
API rows available for you is based on your
\href{https://serpstat.com/pay/}{plan}. Use this method to control the amount
of API rows left.
}
\section{API credits consumption}{
 0
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_sa_stats(api_token)$summary_info$left_lines
}
}
