% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{resampleParticles}
\alias{resampleParticles}
\title{Resample in place to avoid expensive copying of data structures, using a permutation
of the ancestry vector.}
\usage{
resampleParticles(log_weights, ampMx, scaleMx, peaks, baselines, n_y, nwl)
}
\arguments{
\item{log_weights}{logarithms of the importance weights of each particle}

\item{ampMx}{\code{npeaks x npart} Matrix of amplitudes for each particle.}

\item{scaleMx}{\code{npeaks x npart} Matrix of scale parameters for each particle.}

\item{peaks}{\code{nwl x npart} Matrix containing the expectation of the Lorentzian mixture.}

\item{baselines}{\code{nwl x n_y x npart} Array of smoothing splines.}

\item{n_y}{number of observations}

\item{nwl}{number of wavenumbers}
}
\value{
Vector of indices to the parents of the resampled particles.
}
\description{
Resample in place to avoid expensive copying of data structures, using a permutation
of the ancestry vector.
}
\references{
Murray, L.M., Lee, A. & Jacob, P.E. (2015) "Parallel resampling in the particle filter" \href{http://arxiv.org/abs/1301.4019}{arXiv:1301.4019v3}
}
\seealso{
\code{\link{residualResampling}}
}
