% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set.R
\name{contains}
\alias{contains}
\alias{\%inset\%}
\title{Are Elements Contained in the Set?}
\usage{
x \%inset\% y
}
\arguments{
\item{x}{ANY}

\item{y}{\link{Set}}
}
\value{
If \code{all} is TRUE then returns TRUE if all elements of \code{x} are contained in the Set, otherwise
FALSE. If \code{all} is FALSE then returns a vector of logicals corresponding to each individual
element of \code{x}.
}
\description{
Tests to see if \code{x} is contained in the Set.
}
\details{
\code{x} can be of any type, including a Set itself. \code{x} should be a tuple if
checking to see if it lies within a set of dimension greater than one. To test for multiple \code{x}
at the same time, then provide these as a list.

If using the method directly, and not via one of the operators then the additional boolean
arguments \code{all} and \code{bound}. If \code{all = TRUE} then returns \code{TRUE} if all \code{x} are contained in the \code{Set}, otherwise
returns a vector of logicals. For \link{Interval}s, \code{bound} is used to specify if elements lying on the
(possibly open) boundary of the interval are considered contained (\code{bound = TRUE}) or not (\code{bound = FALSE}).
}
\section{R6 Usage}{
 $contains(x, all = FALSE, bound = NULL)
}

\examples{
s = Set$new(1:5)

# Simplest case
s$contains(4)
8 \%inset\% s

# Test if multiple elements lie in the set
s$contains(4:6, all = FALSE)
s$contains(4:6, all = TRUE)

# Check if a tuple lies in a Set of higher dimension
s2 = s * s
s2$contains(Tuple$new(2,1))
c(Tuple$new(2,1), Tuple$new(1,7), 2) \%inset\% s2
}
\seealso{
Other set methods: 
\code{\link{equals}},
\code{\link{isSubset}}
}
\concept{set methods}
